<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankDetailsTable extends Migration {

	public function up()
	{
		Schema::create('bank_details', function(Blueprint $table) {
			$table->increments('id');
			$table->string('account_num', 255)->nullable();
			$table->string('branch', 255)->nullable();
			$table->string('branch_code', 255)->nullable();
			$table->string('zip_code', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('ifsc_code', 255)->nullable();
			$table->string('circle', 255)->nullable();
			$table->string('branch_type', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bank_details');
	}
}