<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->integer('quantity');
			$table->float('price');
			$table->float('fee');
			$table->bigInteger('event_id');
			$table->string('qr_image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}