<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('phone');
			$table->boolean('gender');
			$table->string('password');
			$table->boolean('is_verified')->nullable()->default(0);
			$table->boolean('is_blocked')->nullable()->default(0);
			$table->softDeletes();
			$table->timestamps();
			$table->boolean('is_ambassador')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}