<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('fullName');
			$table->string('avatar')->nullable();
			$table->string('location')->nullable();
			$table->text('bibliography')->nullable();
			$table->string('industry')->nullable();
			$table->string('occupation')->nullable();
			$table->string('expertise')->nullable();
			$table->boolean('hasSetup');
			$table->timestamps();
			$table->string('username')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}