<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Factory extends Model 
{

    protected $table = 'factory';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'sub_title_en', 'sub_title_ar', 'description_en', 'description_ar', 'phone', 'website', 'email', 'facebook', 'twitter', 'instagram', 'linked_in', 'country_id', 'category_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}