<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFactoryRequestsTable extends Migration {

	public function up()
	{
		Schema::create('factory_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('responsible_name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->string('factory_name')->nullable();
			$table->text('address')->nullable();
			$table->string('country')->nullable();
			$table->string('video_link')->nullable();
			$table->text('description')->nullable();
			$table->json('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('factory_requests');
	}
}