<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('iso2');
			$table->string('iso3');
			$table->string('cctld')->nullable();
			$table->string('name')->nullable();
			$table->string('dial_code')->nullable();
			$table->string('currency')->nullable();
			$table->string('ioc')->nullable();
			$table->string('languages')->nullable();
			$table->string('status');
			$table->bigInteger('continent_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}