<?php

namespace App\Models;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;
	protected $fillable = array('title', 'description');

	public function files()
	{
		return $this->morphMany('App\Models\File', 'fileable');
	}

	public function teacher()
	{
		return $this->belongsTo('App\Models\Teacher', 'teacher_id');
	}

	public function views()
	{
		return $this->morphMany('App\Models\View', 'viewable');
	}

	public function comments()
	{
		return $this->morphMany('App\Models\Comment', 'commentable');
	}

	public function favorites()
	{
		return $this->morphMany('App\Models\PostFavourite', 'favouriteable');
	}

}