<?php

namespace App\Models;

class Student extends Eloquent {

	protected $table = 'students';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'phone', 'address', 'longitude', 'latitude', 'profile_image');

	public function academicYear()
	{
		return $this->belongsTo('App\Models\AcademicYear');
	}

	public function ratings()
	{
		return $this->belongsToMany('App\Models\Teacher', 'ratings');
	}

	public function favouriteSubjects()
	{
		return $this->belongsToMany('App\Models\Subject', 'student_subject');
	}

	public function lessons()
	{
		return $this->belongsToMany('App\Models\Lesson', 'student_lesson');
	}

	public function progress()
	{
		return $this->belongsToMany('App\Models\Teacher', 'student_progress')->withPivot(['rate','description']);
	}

	public function parents()
	{
		return $this->belongsToMany('App\Models\Parent', 'student_parent');
	}

	public function presenceAndAbsence()
	{
		return $this->belongsToMany('App\Models\PresenceAbsence', 'presence_absence')->withPivot(['type','date']);
	}

}