<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoices extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'order_id', 'total', 'paid');

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

    public function order()
    {
        return $this->belongsTo('Orders', 'order_id');
    }

}