<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('realty_id');
			$table->integer('unit_id');
			$table->integer('provider_id');
			$table->integer('request_status');
			$table->text('details')->nullable();
			$table->datetime('date')->nullable();
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}