<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepartmentsTable extends Migration {

	public function up()
	{
		Schema::create('Departments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('school_id')->unsigned();
			$table->string('name', 90);
			$table->text('address');
			$table->string('phone', 20);
			$table->string('chair_name', 40);
			$table->string('chair_email', 80)->default('N/A');
			$table->string('contact_name', 40);
			$table->string('contact_email', 80);
			$table->tinyInteger('total_full_faculty');
			$table->smallInteger('total_faculty');
			$table->mediumInteger('total_grad_students');
			$table->smallInteger('total_postdocs');
			$table->smallInteger('total_firstyears');
			$table->tinyInteger('total_firstyear_female')->unsigned();
			$table->text('website');
			$table->string('dom_app_deadline', 100);
			$table->string('int_app_deadline', 100);
			$table->smallInteger('app_fee');
			$table->mediumInteger('int_app_fee');
			$table->boolean('need_gre');
			$table->tinyInteger('need_subj_gre');
			$table->float('min_gpa');
			$table->mediumInteger('app_data_year');
			$table->mediumInteger('apps');
			$table->mediumInteger('admits');
			$table->mediumInteger('enrolled');
			$table->boolean('need_toefl');
			$table->mediumInteger('min_pbt');
			$table->mediumInteger('min_ibt');
			$table->mediumInteger('min_quant_gre');
			$table->mediumInteger('min_verb_gre');
			$table->mediumInteger('min_writ_gre');
			$table->mediumInteger('avg_quant_gre');
			$table->mediumInteger('avg_verb_gre');
			$table->mediumInteger('avg_writ_gre');
			$table->mediumInteger('min_subj_gre');
			$table->mediumInteger('avg_subj_gre');
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('Departments');
	}
}