<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactInfoTable extends Migration {

	public function up()
	{
		Schema::create('contact_info', function(Blueprint $table) {
			$table->increments('id');
			$table->string('address');
			$table->string('landline_numbers');
			$table->string('hotline_number');
			$table->string('whatsApp_number');
			$table->string('youtube_link')->nullable();
			$table->string('tiktok_link')->nullable();
			$table->string('instagram_link')->nullable();
			$table->string('linkedin_link')->nullable();
			$table->string('twitter_link');
			$table->string('facebook_link')->nullable();
			$table->text('map_url')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contact_info');
	}
}