<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntegrationsTable extends Migration {

	public function up()
	{
		Schema::create('integrations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->enum('type', array('RESTAPI', 'Database', 'ExternalService'));
			$table->boolean('Is_enabled');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('integrations');
	}
}