<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Jobs extends Model 
{

    protected $table = 'jobs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('company_id', 'title_id', 'category_id', 'location_id', 'instruction', 'ward_unit', 'job_date', 'start_time', 'end_time', 'job_type', 'assigned_to', 'assigned_type', 'picked_by', 'status', 'is_active');

    public function getStatus()
    {
        return $this->hasOne('JobStatus', 'status', 'id');
    }

    public function getJobtitle()
    {
        return $this->hasOne('JobTitle', 'title_id', 'id');
    }

    public function getCategory()
    {
        return $this->hasOne('ServiceCategory', 'category_id', 'id');
    }

    public function getTimesheet()
    {
        return $this->hasOne('TimeSheet', 'job_id', 'id');
    }

    public function getCompany()
    {
        return $this->hasOne('ClientManager', 'company_id', 'id');
    }

    public function getStaff()
    {
        return $this->hasOne('Staff', 'picked_by', 'id');
    }

}