<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('from_staff', 'from_client', 'from_admin', 'to_staff', 'to_client', 'notification_type', 'is_active');

    public function notificationType()
    {
        return $this->hasOne('NotificationCategories', 'id', 'notification_type');
    }

}