<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('notification_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->text('name')->nullable();
			$table->text('slug')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('notification_categories');
	}
}