<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceCategoryTable extends Migration {

	public function up()
	{
		Schema::create('service_category', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->text('description')->nullable();
			$table->text('image')->nullable();
			$table->tinyInteger('is_active')->nullable();
			$table->integer('created_by')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('service_category');
	}
}