<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTimeSheetTable extends Migration {

	public function up()
	{
		Schema::create('time_sheet', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('job_id')->nullable();
			$table->date('job_date')->nullable();
			$table->time('start_time')->nullable();
			$table->time('end_time')->nullable();
			$table->time('break_time')->nullable();
			$table->text('staff_sign')->nullable();
			$table->string('supervisor_name', 255)->nullable();
			$table->string('supervisor_surname', 255)->nullable();
			$table->tinyInteger('orientation')->nullable();
			$table->text('supervisor_sign')->nullable();
			$table->tinyInteger('incident')->nullable();
			$table->tinyInteger('protocol')->nullable();
			$table->tinyInteger('incident_notified')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('time_sheet');
	}
}