<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_request', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_request', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_branch_id_foreign');
		});
		Schema::table('user_request', function(Blueprint $table) {
			$table->dropForeign('user_request_user_id_foreign');
		});
		Schema::table('user_request', function(Blueprint $table) {
			$table->dropForeign('user_request_item_id_foreign');
		});
	}
}