<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizesTable extends Migration {

	public function up()
	{
		Schema::create('quizes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->bigInteger('classe_id')->unsigned();
			$table->bigInteger('subject_id')->unsigned();
			$table->bigInteger('chapter_id')->unsigned()->nullable();
			$table->bigInteger('board_id')->unsigned();
			$table->bigInteger('exam_type')->unsigned();
			$table->string('description')->nullable();
			$table->string('featured_image')->nullable();
			$table->integer('duration_min');
			$table->string('quiz_instruction')->nullable();
			$table->string('difficulty_level')->nullable();
			$table->integer('number_of_question')->nullable();
			$table->integer('marks_per_question')->nullable()->default('10');
			$table->integer('passing_marks')->nullable()->default('10');
			$table->integer('total_marks');
		});
	}

	public function down()
	{
		Schema::drop('quizes');
	}
}