<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('question_type_id')->references('id')->on('question_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('exam_type_id')->references('id')->on('exam_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subjects', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subjects', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exam_types', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('exam_type')->references('id')->on('exam_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_quiz', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_quiz', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_results', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->foreign('quizresult_id')->references('id')->on('quiz_results')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('textbooks', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('textbooks', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('textbooks', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guides', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guides', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guides', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guides_questions', function(Blueprint $table) {
			$table->foreign('guides_id')->references('id')->on('guides')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guides_questions', function(Blueprint $table) {
			$table->foreign('question_type_id')->references('id')->on('question_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guides_questions', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_classe_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_question_type_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_classe_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_subject_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_chapter_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_exam_type_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_board_id_foreign');
		});
		Schema::table('subjects', function(Blueprint $table) {
			$table->dropForeign('subjects_board_id_foreign');
		});
		Schema::table('subjects', function(Blueprint $table) {
			$table->dropForeign('subjects_classe_id_foreign');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->dropForeign('chapters_board_id_foreign');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->dropForeign('chapters_classe_id_foreign');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->dropForeign('chapters_subject_id_foreign');
		});
		Schema::table('exam_types', function(Blueprint $table) {
			$table->dropForeign('exam_types_classe_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_classe_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_subject_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_chapter_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_board_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_exam_type_foreign');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->dropForeign('quizes_questions_quiz_id_foreign');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->dropForeign('quizes_questions_question_id_foreign');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->dropForeign('quizes_questions_classe_id_foreign');
		});
		Schema::table('quizes_questions', function(Blueprint $table) {
			$table->dropForeign('quizes_questions_subject_id_foreign');
		});
		Schema::table('user_quiz', function(Blueprint $table) {
			$table->dropForeign('user_quiz_user_id_foreign');
		});
		Schema::table('user_quiz', function(Blueprint $table) {
			$table->dropForeign('user_quiz_quiz_id_foreign');
		});
		Schema::table('quiz_results', function(Blueprint $table) {
			$table->dropForeign('quiz_results_quiz_id_foreign');
		});
		Schema::table('quiz_results', function(Blueprint $table) {
			$table->dropForeign('quiz_results_user_id_foreign');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->dropForeign('quiz_user_answers_quiz_id_foreign');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->dropForeign('quiz_user_answers_question_id_foreign');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->dropForeign('quiz_user_answers_user_id_foreign');
		});
		Schema::table('quiz_user_answers', function(Blueprint $table) {
			$table->dropForeign('quiz_user_answers_quizresult_id_foreign');
		});
		Schema::table('textbooks', function(Blueprint $table) {
			$table->dropForeign('textbooks_board_id_foreign');
		});
		Schema::table('textbooks', function(Blueprint $table) {
			$table->dropForeign('textbooks_classe_id_foreign');
		});
		Schema::table('textbooks', function(Blueprint $table) {
			$table->dropForeign('textbooks_subject_id_foreign');
		});
		Schema::table('guides', function(Blueprint $table) {
			$table->dropForeign('guides_board_id_foreign');
		});
		Schema::table('guides', function(Blueprint $table) {
			$table->dropForeign('guides_classe_id_foreign');
		});
		Schema::table('guides', function(Blueprint $table) {
			$table->dropForeign('guides_subject_id_foreign');
		});
		Schema::table('guides_questions', function(Blueprint $table) {
			$table->dropForeign('guides_questions_guides_id_foreign');
		});
		Schema::table('guides_questions', function(Blueprint $table) {
			$table->dropForeign('guides_questions_question_type_id_foreign');
		});
		Schema::table('guides_questions', function(Blueprint $table) {
			$table->dropForeign('guides_questions_chapter_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_board_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_classe_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_subject_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_chapter_id_foreign');
		});
	}
}