<?php

namespace chapter;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Chapter extends Eloquent {

	protected $table = 'chapters';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function board()
	{
		return $this->hasOne('Board');
	}

	public function classe()
	{
		return $this->hasOne('Classe');
	}

	public function subject()
	{
		return $this->hasOne('Subject');
	}

	public function guidequestion()
	{
		return $this->belongsTo('GuideQuestion');
	}

	public function question()
	{
		return $this->belongsTo('Question');
	}

}