<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function role()
	{
		return $this->hasOne('Role');
	}

	public function classe()
	{
		return $this->hasOne('Classe');
	}

	public function userquiz()
	{
		return $this->belongsTo('UserQuiz');
	}

	public function quizresult()
	{
		return $this->belongsTo('QuizResult');
	}

}