<?php

namespace userquiz;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserQuiz extends Eloquent {

	protected $table = 'user_quiz';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasOne('User');
	}

	public function quiz()
	{
		return $this->hasMany('Quiz');
	}

}