<?php

namespace chapter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chapter extends Model 
{

    protected $table = 'chapters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function board()
    {
        return $this->hasOne('Board');
    }

    public function classe()
    {
        return $this->hasOne('Classe');
    }

    public function subject()
    {
        return $this->hasOne('Subject');
    }

    public function guidequestion()
    {
        return $this->belongsTo('GuideQuestion');
    }

    public function question()
    {
        return $this->belongsTo('Question');
    }

}