<?php

namespace subject;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subject extends Model 
{

    protected $table = 'subjects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function chapter()
    {
        return $this->belongsTo('Chapter');
    }

    public function question()
    {
        return $this->belongsTo('Question');
    }

    public function textbook()
    {
        return $this->belongsTo('Textbook');
    }

}