<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('question_type_id')->unsigned()->default('10');
			$table->bigInteger('classe_id')->unsigned()->nullable()->default('10');
			$table->bigInteger('subject_id')->unsigned()->default('10');
			$table->bigInteger('chapter_id')->unsigned()->default('20');
			$table->bigInteger('exam_type_id')->unsigned()->default('20');
			$table->bigInteger('board_id')->unsigned();
			$table->string('question')->nullable();
			$table->string('option1')->nullable();
			$table->string('option2')->nullable();
			$table->string('option3')->nullable();
			$table->string('option4')->nullable();
			$table->string('answer1')->nullable();
			$table->string('answer2')->nullable();
			$table->string('answer1_image')->nullable();
			$table->string('answer2_image')->nullable();
			$table->string('Exaplaination')->nullable();
			$table->string('answer3')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}