<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('qrcode_id')->references('id')->on('qrcodes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('entity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checkings', function(Blueprint $table) {
			$table->foreign('qrcode_id')->references('id')->on('qrcodes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checkings', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_entity_id_foreign');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_qrcode_id_foreign');
		});
		Schema::table('entity', function(Blueprint $table) {
			$table->dropForeign('entity_parent_id_foreign');
		});
		Schema::table('checkings', function(Blueprint $table) {
			$table->dropForeign('checkings_qrcode_id_foreign');
		});
		Schema::table('checkings', function(Blueprint $table) {
			$table->dropForeign('checkings_entity_id_foreign');
		});
	}
}