<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComptesTable extends Migration {

	public function up()
	{
		Schema::create('comptes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('typecompte_id')->unsigned();
			$table->integer('institution_id')->unsigned()->index();
			$table->integer('fournisseur_id')->unsigned();
			$table->date('begda')->index();
			$table->date('endda')->index();
			$table->string('nom', 150)->unique();
			$table->string('numero', 100)->unique()->nullable();
			$table->decimal('solde_depart', 9,2)->default('0.00');
			$table->decimal('solde', 9,2);
			$table->decimal('budget', 9,2)->nullable();
			$table->decimal('engagement', 9,2)->nullable();
			$table->decimal('disponible', 9,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('comptes');
	}
}