<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('receive_order_type');
			$table->bigInteger('district_id')->unsigned();
			$table->string('address_description');
			$table->string('address');
			$table->decimal('lat');
			$table->decimal('long');
			$table->string('nearest_landmark');
			$table->decimal('product_price');
			$table->decimal('delivery_price')->nullable();
			$table->decimal('tax');
			$table->string('status');
			$table->timestamps();
			$table->string('rate');
			$table->text('comment');
			$table->bigInteger('user_id');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}