<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Antecedent extends Model 
{

    protected $table = 'antecendents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function patient_backgrounds()
    {
        return $this->hasMany('PatientBackground');
    }

    public function diagnostics()
    {
        return $this->hasMany('Diagnostic');
    }

}