<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobTitle extends Model 
{

    protected $table = 'job_titles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function jobTitleTranslations()
    {
        return $this->hasMany('JobTitleTranslation');
    }

    public function director()
    {
        return $this->belongsTo('Director');
    }

}