<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tenant_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('consumption_unit_id')->unsigned()->nullable();
			$table->string('ref_id');
			$table->string('invoice_reference');
			$table->string('designation');
			$table->string('transactional_info')->nullable();
			$table->string('method');
			$table->double('amount_total');
			$table->double('amount_pending');
			$table->string('amount_currency');
			$table->datetime('due_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}