<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHelpContentsTable extends Migration {

	public function up()
	{
		Schema::create('help_contents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('category_type', 255);
			$table->bigInteger('category_id')->unsigned();
			$table->string('short_description', 255)->nullable();
			$table->text('detailed_content')->nullable();
			$table->timestamp('published_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('help_contents');
	}
}