<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 256);
			$table->string('email', 256);
			$table->string('mobile', 125);
			$table->string('photo', 256)->nullable();
			$table->string('location', 256);
			$table->string('latitude', 125);
			$table->string('longitude', 125);
			$table->integer('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}