<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBmtTable extends Migration {

	public function up()
	{
		Schema::create('bmt', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 256);
			$table->string('tagline', 256)->nullable();
			$table->string('thumbnail', 256);
			$table->string('video', 256);
			$table->integer('is_featured')->default('0');
			$table->integer('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bmt');
	}
}