<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('role_permission', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admin_users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_otp', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('simply_simplified', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('simply_simplified_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ias_me_graduate', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('ias_me_graduate_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ias_me_school', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('ias_me_school_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mains_gear_advanced_solution', function(Blueprint $table) {
			$table->foreign('mains_gear_advanced_id')->references('id')->on('mains_gear_advanced')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('testpresso', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('testpresso_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('testpresso_options', function(Blueprint $table) {
			$table->foreign('testpresso_id')->references('id')->on('testpresso')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_test_results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_test_results', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('testpresso')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_devices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_video_log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_varients', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_plan', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_plan', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->foreign('user_plan_id')->references('id')->on('user_plan')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('role_permission', function(Blueprint $table) {
			$table->dropForeign('role_permission_role_id_foreign');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->dropForeign('role_permission_permission_id_foreign');
		});
		Schema::table('admin_users', function(Blueprint $table) {
			$table->dropForeign('admin_users_role_id_foreign');
		});
		Schema::table('user_otp', function(Blueprint $table) {
			$table->dropForeign('user_otp_user_id_foreign');
		});
		Schema::table('simply_simplified', function(Blueprint $table) {
			$table->dropForeign('simply_simplified_category_id_foreign');
		});
		Schema::table('ias_me_graduate', function(Blueprint $table) {
			$table->dropForeign('ias_me_graduate_category_id_foreign');
		});
		Schema::table('ias_me_school', function(Blueprint $table) {
			$table->dropForeign('ias_me_school_category_id_foreign');
		});
		Schema::table('mains_gear_advanced_solution', function(Blueprint $table) {
			$table->dropForeign('mains_gear_advanced_solution_mains_gear_advanced_id_foreign');
		});
		Schema::table('testpresso', function(Blueprint $table) {
			$table->dropForeign('testpresso_category_id_foreign');
		});
		Schema::table('testpresso_options', function(Blueprint $table) {
			$table->dropForeign('testpresso_options_testpresso_id_foreign');
		});
		Schema::table('user_test_results', function(Blueprint $table) {
			$table->dropForeign('user_test_results_user_id_foreign');
		});
		Schema::table('user_test_results', function(Blueprint $table) {
			$table->dropForeign('user_test_results_test_id_foreign');
		});
		Schema::table('user_devices', function(Blueprint $table) {
			$table->dropForeign('user_devices_user_id_foreign');
		});
		Schema::table('user_video_log', function(Blueprint $table) {
			$table->dropForeign('user_video_log_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('plan_varients', function(Blueprint $table) {
			$table->dropForeign('plan_varients_plan_id_foreign');
		});
		Schema::table('user_plan', function(Blueprint $table) {
			$table->dropForeign('user_plan_user_id_foreign');
		});
		Schema::table('user_plan', function(Blueprint $table) {
			$table->dropForeign('user_plan_plan_id_foreign');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->dropForeign('user_feature_availables_user_id_foreign');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->dropForeign('user_feature_availables_plan_id_foreign');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->dropForeign('user_feature_availables_user_plan_id_foreign');
		});
	}
}