<?php

namespace Rockit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Artist extends Model 
{

    protected $table = 'artists';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function links()
    {
        return $this->hasMany('Link');
    }

    public function genres()
    {
        return $this->belongsToMany('Genre');
    }

    public function images()
    {
        return $this->hasMany('Image');
    }

    public function lineups()
    {
        return $this->hasMany('Lineup');
    }

    public function events()
    {
        return $this->belongsToMany('Event')->withPivot('order','is_support','artist_hour_of_arrival');
    }

}