<?php

namespace Rockit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function groupParent()
    {
        return $this->hasOne('Group', 'childGroup_id');
    }

    public function resources()
    {
        return $this->hasMany('Resource');
    }

    public function users()
    {
        return $this->hasMany('User');
    }

}