<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->string('email', 255)->nullable();
			$table->string('phone', 40)->nullable();
			$table->text('address')->nullable();
			$table->string('logo', 255)->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->boolean('verified_mail')->default(0);
			$table->longText('about')->nullable();
			$table->integer('otp')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}