<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('question_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('topic_details', function(Blueprint $table) {
			$table->foreign('topic_id')->references('id')->on('topics')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('topic_detail_id')->references('id')->on('topic_details')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('operator_id')->references('id')->on('operators')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('ticket_category_id')->references('id')->on('ticket_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ticket_replies', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('representatives', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('representatives', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_category_id_foreign');
		});
		Schema::table('topic_details', function(Blueprint $table) {
			$table->dropForeign('topic_details_topic_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_topic_detail_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_company_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_operator_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_client_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_ticket_category_id_foreign');
		});
		Schema::table('ticket_replies', function(Blueprint $table) {
			$table->dropForeign('ticket_replies_ticket_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_country_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_city_id_foreign');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->dropForeign('operators_country_id_foreign');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->dropForeign('operators_city_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_country_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_city_id_foreign');
		});
		Schema::table('representatives', function(Blueprint $table) {
			$table->dropForeign('representatives_country_id_foreign');
		});
		Schema::table('representatives', function(Blueprint $table) {
			$table->dropForeign('representatives_city_id_foreign');
		});
	}
}