<?php

namespace Models/Client;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function client_country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function client_city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}