<?php

namespace Models/Operator;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Operator extends Model 
{

    protected $table = 'operators';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function operator_country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function operator_city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}