<?php

namespace Models/Ticket;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ticket_category()
    {
        return $this->belongsTo('TicketCategory', 'topic_detail_id');
    }

    public function ticket_client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function ticket_operator()
    {
        return $this->belongsTo('Operator', 'operator_id');
    }

    public function ticket_company()
    {
        return $this->belongsTo('Company', 'company_id');
    }

    public function ticket_representative()
    {
        return $this->belongsTo('Representative', 'representative_id');
    }

}