<?php

namespace Models/Company;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company_country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function company_city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}