<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_membership', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_membership', function(Blueprint $table) {
			$table->foreign('membership_id')->references('id')->on('memberships')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_alert', function(Blueprint $table) {
			$table->foreign('alertconfig_id')->references('id')->on('AlertConfig')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_alert', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_membership', function(Blueprint $table) {
			$table->dropForeign('user_membership_user_id_foreign');
		});
		Schema::table('user_membership', function(Blueprint $table) {
			$table->dropForeign('user_membership_membership_id_foreign');
		});
		Schema::table('user_alert', function(Blueprint $table) {
			$table->dropForeign('user_alert_alertconfig_id_foreign');
		});
		Schema::table('user_alert', function(Blueprint $table) {
			$table->dropForeign('user_alert_user_id_foreign');
		});
	}
}