<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EventType extends Eloquent {

	protected $table = 'event_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function site()
	{
		return $this->belongsTo('Site');
	}

	public function campaigns()
	{
		return $this->belongsToMany('CampaignEventType');
	}

}