<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id');
			$table->string('amount');
			$table->enum('method', array('cash', 'card', 'stripe'));
			$table->enum('status', array('success', 'failed', 'pending'));
			$table->bigInteger('subscription_id');
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}