<?php

namespace App\Models;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function addresses()
	{
		return $this->hasMany('Address', 'addressable');
	}

	public function phones()
	{
		return $this->morphMany('Phone', 'phoneable');
	}

}